/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning.mokos;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cz.insophy.inplan.plan.ActionActivity;
import cz.insophy.inplan.planning.mokos.Operation;
import cz.insophy.inplan.planning.mokos.Processor;
import cz.insophy.inplan.planning.mokos.Scheduler;
import cz.insophy.inplan.property.PropertyDefinition;
import cz.insophy.inplan.shop.Action;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.shop.MaterialQuantity;
import cz.insophy.inplan.shop.Product;
import cz.insophy.inplan.shop.ShopConfiguration;
import cz.insophy.inplan.store.InPlanStoreActivity;
import cz.insophy.inplan.store.StoreActivity;
import cz.insophy.inplan.store.StoreActivityOwner;
import cz.insophy.inplan.store.StoreSchedule;
import cz.insophy.inplan.store.StoreType;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedRequest;
import cz.insophy.inplan.superplan.ProductionTreeAlgorithms;
import cz.insophy.inplan.superplan.ProductionTreeVisitorAdapter;
import cz.insophy.inplan.superplan.Superplan;
import cz.insophy.inplan.util.Tuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaterialBoundUpdater2
extends Processor {
    private static final Logger log = LoggerFactory.getLogger(MaterialBoundUpdater2.class);
    private StoreSchedule.MatHorizonTreatment matHorizonTreatment = StoreSchedule.MatHorizonTreatment.MATERIAL_SPECIFIC;
    private Map<Material, MaterialInfo> matInfos;
    private long lastMinTime;
    private StealingMaterials stealingMaterials = StealingMaterials.NONE;
    private PropertyDefinition prodStealPd;
    private PropertyDefinition matStealPd;
    private PropertyDefinition pullOrderPd;
    private String pullOrderPropertyName = "pullOrder";
    private static final String PREVENT_STEALING_PROPERTY = "preventStealing";
    private static final String DEFAULT_PULL_ORDER_PROPERTY_NAME = "pullOrder";

    public MaterialBoundUpdater2() {
        this.matInfos = Maps.newIdentityHashMap();
    }

    public void setMatHorizonTreatment(StoreSchedule.MatHorizonTreatment matHorizonTreatment) {
        this.matHorizonTreatment = matHorizonTreatment;
    }

    public void setStealingMaterials(StealingMaterials stealingMaterials) {
        this.stealingMaterials = stealingMaterials;
    }

    public void setPullOrderPropertyName(String pullOrderPropertyName) {
        this.pullOrderPropertyName = pullOrderPropertyName;
    }

    private void initStealingPropdefs(ShopConfiguration conf) {
        if (this.stealingMaterials == StealingMaterials.NONE) {
            return;
        }
        this.pullOrderPd = conf.getPropertyDefinition(GeneralizedActionRequest.class, this.pullOrderPropertyName);
        if (this.pullOrderPd == null) {
            throw new IllegalStateException("Material stealing prevention requested but there is no GAR." + this.pullOrderPropertyName + " property.");
        }
        if (this.pullOrderPd.getType() != PropertyDefinition.PropertyType.LONG) {
            throw new IllegalStateException("Invalid type of GAR." + this.pullOrderPropertyName + " property. Expected LONG got " + this.pullOrderPd.getType());
        }
        if (this.stealingMaterials == StealingMaterials.ALL) {
            return;
        }
        this.matStealPd = conf.getPropertyDefinition(Material.class, PREVENT_STEALING_PROPERTY);
        if (this.matStealPd != null && this.matStealPd.getType() != PropertyDefinition.PropertyType.BOOLEAN) {
            log.warn("{} property on material has not a boolean type. Ignoring stealing for materials.", (Object)PREVENT_STEALING_PROPERTY);
            this.matStealPd = null;
        }
        this.prodStealPd = conf.getPropertyDefinition(Product.class, PREVENT_STEALING_PROPERTY);
        if (this.prodStealPd != null && this.prodStealPd.getType() != PropertyDefinition.PropertyType.BOOLEAN) {
            log.warn("{} property on product has not a boolean type. Ignoring stealing for products.", (Object)PREVENT_STEALING_PROPERTY);
            this.prodStealPd = null;
        }
    }

    @Nonnull
    @VisibleForTesting
    List<Operation> getSortedOperations(Set<Operation> operations) {
        ArrayList<Operation> opsList = new ArrayList<Operation>(operations);
        opsList.sort(new OpsComparator());
        return opsList;
    }

    @Override
    public void setScheduler(Scheduler scheduler) {
        super.setScheduler(scheduler);
        Superplan superplan = this.getScheduler().getSuperplan();
        this.initStealingPropdefs(superplan.getShopConf());
        long fixationDate = superplan.getFixationDate();
        Preconditions.checkState(GeneralizedRequest.isDateValid(fixationDate), "Superplan must have fixation date.");
        this.lastMinTime = fixationDate;
        StoreSchedule ss = superplan.getPlan().getStoreSchedule(StoreType.ACTUAL_ESTIMATE_VIEW);
        Collection<Operation> ops = this.pullOrderPd != null ? this.getSortedOperations(scheduler.getOperations()) : scheduler.getOperations();
        for (Operation operation : ops) {
            boolean isMainLa = operation.getAction().isMainLocalAlt();
            if (isMainLa && operation.hasLag()) {
                this.checkLag(operation.getLaOps());
            }
            Action action = operation.getAction();
            long minTimeBeforeOffset = MaterialBoundUpdater2.getMinTimeBeforeOffset(operation);
            for (Material m3 : action.getBom().materials()) {
                if (!m3.isConsumed()) continue;
                double reqQty = MaterialBoundUpdater2.getQtyToPlan(operation, operation.getGar(), m3);
                MaterialInfo mi = this.matInfos.computeIfAbsent(m3, mat -> new MaterialInfo(this.hasStealingPrevention((Material)mat)));
                mi.addRequestedQty(operation, reqQty);
                if (mi.maxFirstTimeToPrepare >= minTimeBeforeOffset) continue;
                mi.maxFirstTimeToPrepare = minTimeBeforeOffset;
            }
        }
        for (Map.Entry entry : this.matInfos.entrySet()) {
            Material m4 = (Material)entry.getKey();
            MaterialInfo mi = (MaterialInfo)entry.getValue();
            mi.quota = new InternalQuota(ss, m4, fixationDate - mi.maxFirstTimeToPrepare, this.matHorizonTreatment, fixationDate, mi.preventStealing);
            for (Tuple<Operation, Double> tuple : mi.requestedQties) {
                this.setBounds(tuple.getFirst(), m4, mi.quota, tuple.getSecond());
            }
        }
    }

    private void checkLag(Collection<Operation> lagOps) {
        if (this.stealingMaterials == StealingMaterials.NONE) {
            return;
        }
        ArrayList<Operation> ops = Lists.newArrayList(lagOps);
        List boms = ops.stream().map(op -> op.getAction().getBom().ingredients().stream().filter(mq -> this.hasStealingPrevention(mq.getMaterial())).map(mq -> Tuple.create(mq.getMaterial(), mq.getQty())).collect(Collectors.toSet())).collect(Collectors.toList());
        for (int i = 0; i < ops.size() - 1; ++i) {
            Operation op1 = (Operation)ops.get(i);
            Set bom1 = (Set)boms.get(i);
            Operation op2 = (Operation)ops.get(i + 1);
            Set bom2 = (Set)boms.get(i + 1);
            if (bom1.equals(bom2)) continue;
            throw new IllegalStateException(String.format("Operations %s and %s are in a LAG and have different stealing prevented materials in BOM.\n%s has extra: %s\n%s has extra: %s", op1, op2, op1, Sets.difference(bom1, bom2), op2, Sets.difference(bom2, bom1)));
        }
    }

    @Override
    public void setSuccessors(List<Processor> successors) {
        super.setSuccessors(successors);
        this.checkOneSuccessor();
    }

    @Override
    public Tuple<Processor, Set<Operation>> process(Set<Operation> ops) {
        return Tuple.create(this.getDefaultSuccessor(), ops);
    }

    @Override
    public void onOperationPlanned(Operation op) {
        super.onOperationPlanned(op);
        Action action = op.getAction();
        this.lastMinTime = op.getBound().getTime();
        ArrayList<StoreActivity> sas = Lists.newArrayList();
        for (MaterialQuantity mq : Iterables.concat(action.getBom().ingredients(), action.getProduces())) {
            Material mat = mq.getMaterial();
            MaterialInfo info = this.matInfos.get(mat);
            if (info == null) continue;
            op.getGar().accept(new InPlanSaCollector(mat, sas), false);
            InternalQuota quota = info.quota;
            quota.addPlanned(sas);
            quota.setTime(this.lastMinTime - info.maxFirstTimeToPrepare);
            sas.clear();
            for (Tuple<Operation, Double> opQty : info.requestedQties) {
                Operation affectedOp = opQty.getFirst();
                if (affectedOp.isPlanned()) continue;
                double reqQty = opQty.getSecond();
                this.setBounds(affectedOp, mat, quota, reqQty);
            }
        }
    }

    private void setBounds(Operation op, Material mat, InternalQuota quota, double reqQty) {
        if (op.isPlanned()) {
            return;
        }
        long bound = quota.getAvailabilityOf(reqQty);
        if (GeneralizedRequest.isDateValid(bound)) {
            long minTimeOffset = MaterialBoundUpdater2.getMinTimeBeforeOffset(op);
            bound = Math.max(bound + minTimeOffset, this.lastMinTime);
        }
        op.updateSimpleBound(mat, bound);
    }

    private boolean hasStealingPrevention(Material m3) {
        switch (this.stealingMaterials) {
            case NONE: {
                return false;
            }
            case ALL: {
                return true;
            }
            case PROPERTY_BASED: {
                PropertyDefinition pd;
                PropertyDefinition propertyDefinition = pd = m3 instanceof Product ? this.prodStealPd : this.matStealPd;
                if (pd == null) {
                    return false;
                }
                Boolean ps = (Boolean)m3.getProperty(pd);
                return ps != null && ps != false;
            }
        }
        throw new IllegalStateException("Unexpected stealing mode " + this.stealingMaterials);
    }

    private static double getQtyToPlan(Operation op, GeneralizedActionRequest gar, Material mat) {
        double inPlanQtyMat;
        double v = gar.getRequestedQty() - gar.getOutOfPlanMat();
        if (gar.getInPlanQty() > 0.0) {
            InPlanMatQtyComputer inPlanMatQtyComputer = new InPlanMatQtyComputer(mat);
            gar.accept(inPlanMatQtyComputer, false);
            inPlanQtyMat = inPlanMatQtyComputer.getInPlanQty();
        } else {
            inPlanQtyMat = 0.0;
        }
        double bomFactor = op.getAction().getBom().getQty(mat);
        double qty = (mat.isConstant() ? 1.0 : v) * bomFactor - inPlanQtyMat;
        if (qty < 0.0) {
            qty = 0.0;
        }
        return qty;
    }

    private static long getMinTimeBeforeOffset(Operation op) {
        return op.isActiongramStart() ? op.getAction().getMinTimeToPrepare() : 0L;
    }

    @VisibleForTesting
    static <T extends Comparable<? super T>> void merge(List<T> list, int from) {
        int n = list.size();
        if (n <= 1 || from == 0 || from == n) {
            return;
        }
        int l = 0;
        int r = from;
        Comparable le = (Comparable)list.get(l);
        Comparable re = (Comparable)list.get(r);
        while (l < from && r < n) {
            if (le.compareTo(re) < 0) {
                list.add(le);
                le = (Comparable)list.get(++l);
                continue;
            }
            list.add(re);
            re = (Comparable)list.get(++r);
        }
        list.addAll(list.subList(l, from));
        list.addAll(list.subList(r, n));
        list.subList(0, n).clear();
    }

    public static enum StealingMaterials {
        NONE,
        ALL,
        PROPERTY_BASED;

    }

    private class OpsComparator
    implements Comparator<Operation> {
        private OpsComparator() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int compare(Operation o1, Operation o2) {
            String gorId2;
            if (o1 == o2) {
                return 0;
            }
            int res = 0;
            Long pull1 = (Long)o1.getGar().getProperty(MaterialBoundUpdater2.this.pullOrderPd);
            Long pull2 = (Long)o2.getGar().getProperty(MaterialBoundUpdater2.this.pullOrderPd);
            if (pull1 != null) {
                if (pull2 == null) return -1;
                res = pull1.compareTo(pull2);
            } else if (pull2 != null) {
                return 1;
            }
            if (res != 0) {
                return res;
            }
            String gorId1 = ProductionTreeAlgorithms.getNearestGor(o1.getGar()).getId();
            res = gorId1.compareTo(gorId2 = ProductionTreeAlgorithms.getNearestGor(o2.getGar()).getId());
            if (res != 0) {
                return res;
            }
            Action a1 = o1.getAction();
            Action a2 = o2.getAction();
            res = a1.getName().compareTo(a2.getName());
            if (res != 0) {
                return res;
            }
            if (a1.isMainLocalAlt()) {
                return -1;
            }
            if (!a2.isMainLocalAlt()) return a1.getLocalAltName().compareTo(a2.getLocalAltName());
            return 1;
        }
    }

    private static class MaterialInfo {
        InternalQuota quota;
        final List<Tuple<Operation, Double>> requestedQties = Lists.newArrayList();
        long maxFirstTimeToPrepare;
        final boolean preventStealing;

        MaterialInfo(boolean preventStealing) {
            this.preventStealing = preventStealing;
            this.maxFirstTimeToPrepare = 0L;
        }

        void addRequestedQty(Operation op, double qty) {
            if (this.preventStealing) {
                if (!op.getAction().isMainLocalAlt()) {
                    qty = 0.0;
                }
                if (!this.requestedQties.isEmpty()) {
                    qty += this.requestedQties.get(this.requestedQties.size() - 1).getSecond().doubleValue();
                }
            }
            this.requestedQties.add(Tuple.create(op, qty));
        }
    }

    private static class InternalQuota {
        final boolean cumulative;
        private long time;
        private final long horizonTime;
        private double qty;
        private ArrayList<StoreActivity> futureSas;

        InternalQuota(StoreSchedule storeSchedule, Material mat, long time, StoreSchedule.MatHorizonTreatment horizonTreatment, long horizonBase, boolean cumulative) {
            this.time = time;
            this.futureSas = new ArrayList();
            this.horizonTime = this.initHorizonTime(mat, horizonBase, horizonTreatment);
            this.cumulative = cumulative;
            this.resolveActivities(storeSchedule.getActivities(mat));
        }

        private long initHorizonTime(Material mat, long horizonBase, StoreSchedule.MatHorizonTreatment horizonTreatment) {
            boolean hasHorizon = GeneralizedRequest.isDateValid(mat.getMaterialHorizon());
            return switch (horizonTreatment) {
                case StoreSchedule.MatHorizonTreatment.NO_HORIZONS -> Long.MAX_VALUE;
                case StoreSchedule.MatHorizonTreatment.MATERIAL_SPECIFIC -> hasHorizon ? horizonBase + mat.getMaterialHorizon() : Long.MAX_VALUE;
                case StoreSchedule.MatHorizonTreatment.NULL_FINITE -> hasHorizon ? horizonBase : Long.MAX_VALUE;
                case StoreSchedule.MatHorizonTreatment.NULL_MATERIALS -> mat instanceof Product ? horizonBase + mat.getMaterialHorizon() : horizonBase;
                case StoreSchedule.MatHorizonTreatment.NULL_ALL -> horizonBase;
                default -> throw new IllegalStateException("Unsupported horizonTreatment: " + horizonTreatment);
            };
        }

        private void resolveActivities(Iterable<StoreActivity> activities) {
            for (StoreActivity sa : activities) {
                if (sa.getTime() > this.horizonTime || this.cumulative && sa.getQty() < 0.0) continue;
                if (sa.getQty() < 0.0 || sa.getTime() <= this.time) {
                    this.qty += sa.getQty();
                    continue;
                }
                this.futureSas.add(sa);
            }
        }

        void addPlanned(Iterable<StoreActivity> sas) {
            int oldSize = this.futureSas.size();
            this.resolveActivities(sas);
            int size = this.futureSas.size();
            Collections.sort(this.futureSas.subList(oldSize, size));
            MaterialBoundUpdater2.merge(this.futureSas, oldSize);
        }

        void setTime(long time) {
            Preconditions.checkArgument(time >= this.time, "time can only move forward");
            this.time = time;
            if (time < this.horizonTime) {
                int n = 0;
                for (StoreActivity sa : this.futureSas) {
                    if (sa.getTime() > time) break;
                    ++n;
                    this.qty += sa.getQty();
                }
                this.futureSas.subList(0, n).clear();
            } else {
                this.futureSas.clear();
                this.qty = Double.NaN;
            }
        }

        long getAvailabilityOf(double requestedQty) {
            if (this.time >= this.horizonTime) {
                return this.horizonTime;
            }
            if (requestedQty <= this.qty + 1.0E-7) {
                return this.time;
            }
            double q = this.qty;
            for (StoreActivity sa : this.futureSas) {
                if (!(requestedQty <= (q += sa.getQty()) + 1.0E-7)) continue;
                return sa.getTime();
            }
            return this.horizonTime;
        }
    }

    private static class InPlanSaCollector
    extends ProductionTreeVisitorAdapter {
        private final Material material;
        private List<StoreActivity> storeActivities;

        InPlanSaCollector(Material material, List<StoreActivity> storeActivities) {
            this.material = material;
            this.storeActivities = storeActivities;
        }

        @Override
        public void visit(GeneralizedActionRequest gar) {
            this.visitSao(gar);
        }

        @Override
        public void visit(ActionActivity aa) {
            this.visitSao(aa);
        }

        private void visitSao(StoreActivityOwner sao) {
            for (InPlanStoreActivity inPlanStoreActivity : sao.getStoreActivities()) {
                if (inPlanStoreActivity.getStoreType() != StoreType.INPLAN_ACTUAL || inPlanStoreActivity.getMaterial() != this.material) continue;
                this.storeActivities.add(inPlanStoreActivity);
            }
        }
    }

    private static class InPlanMatQtyComputer
    extends ProductionTreeVisitorAdapter {
        private final Material material;
        private double inPlanQty;

        InPlanMatQtyComputer(Material material) {
            this.material = material;
        }

        @Override
        public void visit(GeneralizedActionRequest gar) {
            this.visitSao(gar);
        }

        @Override
        public void visit(ActionActivity aa) {
            this.visitSao(aa);
        }

        private void visitSao(StoreActivityOwner sao) {
            for (InPlanStoreActivity inPlanStoreActivity : sao.getStoreActivities()) {
                if (!(inPlanStoreActivity.getQty() < 0.0) || inPlanStoreActivity.getStoreType() != StoreType.INPLAN_ACTUAL || inPlanStoreActivity.getMaterial() != this.material) continue;
                this.inPlanQty += inPlanStoreActivity.getAbsQty();
            }
        }

        public double getInPlanQty() {
            return this.inPlanQty;
        }
    }
}

